﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml;
using Gemini.Core.BL.Interface.BO;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        #region Setup
        public override void Setup()
        {
            base.Setup();

            Environment.SetupGroup(ClientID, (int)Dictionary.GroupType.Supervisor, CreateInstruktorGroupStub);
            Environment.SetupGroup(ClientID, (int)Dictionary.GroupType.Student, CreateStudentGroupStub);
            Environment.SetupGroup(ClientID, (int)Dictionary.GroupType.Instructor, CreateTeacherGroupStub);

            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.AdvancedTest, BL.Dictionary.Category.CourseType.AdvancedTest.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.Case, BL.Dictionary.Category.CourseType.Case.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.CompetenceCourse, BL.Dictionary.Category.CourseType.CompetenceCourse.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.CompetenceTheory, BL.Dictionary.Category.CourseType.CompetenceTheory.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.CourseType, (int)BL.Dictionary.Category.CourseType.KnowledgeTest, BL.Dictionary.Category.CourseType.KnowledgeTest.ToString());

            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty, (int)BL.Dictionary.Category.DifficultyType.A, BL.Dictionary.Category.DifficultyType.A.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty, (int)BL.Dictionary.Category.DifficultyType.B, BL.Dictionary.Category.DifficultyType.B.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty, (int)BL.Dictionary.Category.DifficultyType.C, BL.Dictionary.Category.DifficultyType.C.ToString());
            RBL.ELearning.Categorizatoin.Register((int)PI.GM.N610.ELearning.BL.Dictionary.CategoryType.Difficulty, (int)BL.Dictionary.Category.DifficultyType.Instructor, BL.Dictionary.Category.DifficultyType.Instructor.ToString());
        }

        private Gemini.Core.BL.Interface.IGroupStub CreateInstruktorGroupStub()
        {
            return new Gemini.Core.BL.BO.GroupStub() { ClientID = ClientID, EnumID = (int)Dictionary.GroupType.Supervisor, IsWebApplication = true, IsWinForms = true, Name = Dictionary.Text.Group.Instructor.Value };
        }

        private Gemini.Core.BL.Interface.IGroupStub CreateStudentGroupStub()
        {
            return new Gemini.Core.BL.BO.GroupStub() { ClientID = ClientID, EnumID = (int)Dictionary.GroupType.Student, IsWebApplication = true, IsWinForms = false, Name = Dictionary.Text.Group.Student.Value, IsHidden = true };
        }

        private Gemini.Core.BL.Interface.IGroupStub CreateTeacherGroupStub()
        {
            return new Gemini.Core.BL.BO.GroupStub() { ClientID = ClientID, EnumID = (int)Dictionary.GroupType.Instructor, IsWebApplication = true, IsWinForms = false, Name = Dictionary.Text.Group.Teacher.Value, IsHidden = true };
        }
        #endregion
    }
}
